{ *********************************************************************** }
{                                                                         }
{ Translated Header File                                                  }
{ Part of the Delphi Visual Component Library                             }
{                                                                         }
{ Original Header File Copyright (c) 1985-2004 Microsoft Corporation      }
{  All Rights Reserved.                                                   }
{                                                                         }
{ Translation Copyright (c) 1995-2004 Borland Software Corporation        }
{                                                                         }
{ *********************************************************************** }

unit Borland.Vcl.WinSpool platform;

{$WEAKPACKAGEUNIT}

interface

uses System.Runtime.InteropServices, System.Text, Windows;

type
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _PRINTER_INFO_1 = record
    Flags: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDescription: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pComment: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _PRINTER_INFO_1A = record
    Flags: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDescription: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pComment: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _PRINTER_INFO_1W = record
    Flags: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDescription: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pComment: string;
  end;
  TPrinterInfo1 = _PRINTER_INFO_1;
  TPrinterInfo1A = _PRINTER_INFO_1A;
  TPrinterInfo1W = _PRINTER_INFO_1W;
  PRINTER_INFO_1 = _PRINTER_INFO_1;
  PRINTER_INFO_1A = _PRINTER_INFO_1A;
  PRINTER_INFO_1W = _PRINTER_INFO_1W;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _PRINTER_INFO_2 = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pServerName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrinterName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pShareName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPortName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDriverName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pComment: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pLocation: string;
    pDevMode: IntPtr; { PDeviceMode }
    [MarshalAs(UnmanagedType.LPTStr)]
    pSepFile: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrintProcessor: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDatatype: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pParameters: string;
    pSecurityDescriptor: IntPtr;
    Attributes: DWORD;
    Priority: DWORD;
    DefaultPriority: DWORD;
    StartTime: DWORD;
    UntilTime: DWORD;
    Status: DWORD;
    cJobs: DWORD;
    AveragePPM: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _PRINTER_INFO_2A = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pServerName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrinterName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pShareName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPortName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDriverName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pComment: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pLocation: string;
    pDevMode: IntPtr; { PDeviceModeA }
    [MarshalAs(UnmanagedType.LPTStr)]
    pSepFile: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrintProcessor: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDatatype: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pParameters: string;
    pSecurityDescriptor: IntPtr;
    Attributes: DWORD;
    Priority: DWORD;
    DefaultPriority: DWORD;
    StartTime: DWORD;
    UntilTime: DWORD;
    Status: DWORD;
    cJobs: DWORD;
    AveragePPM: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _PRINTER_INFO_2W = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pServerName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrinterName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pShareName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPortName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDriverName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pComment: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pLocation: string;
    pDevMode: IntPtr; { PDeviceModeW }
    [MarshalAs(UnmanagedType.LPTStr)]
    pSepFile: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrintProcessor: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDatatype: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pParameters: string;
    pSecurityDescriptor: IntPtr;
    Attributes: DWORD;
    Priority: DWORD;
    DefaultPriority: DWORD;
    StartTime: DWORD;
    UntilTime: DWORD;
    Status: DWORD;
    cJobs: DWORD;
    AveragePPM: DWORD;
  end;
  TPrinterInfo2 = _PRINTER_INFO_2;
  TPrinterInfo2A = _PRINTER_INFO_2A;
  TPrinterInfo2W = _PRINTER_INFO_2W;
  PRINTER_INFO_2 = _PRINTER_INFO_2;
  PRINTER_INFO_2A = _PRINTER_INFO_2A;
  PRINTER_INFO_2W = _PRINTER_INFO_2W;

  [StructLayout(LayoutKind.Sequential)]
  _PRINTER_INFO_3 = record
    pSecurityDescriptor: IntPtr;
  end;
  TPrinterInfo3 = _PRINTER_INFO_3;
  PRINTER_INFO_3 = _PRINTER_INFO_3;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _PRINTER_INFO_4 = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrinterName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pServerName: string;
    Attributes: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _PRINTER_INFO_4A = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrinterName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pServerName: string;
    Attributes: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _PRINTER_INFO_4W = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrinterName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pServerName: string;
    Attributes: DWORD;
  end;
  TPrinterInfo4 = _PRINTER_INFO_4;
  TPrinterInfo4A = _PRINTER_INFO_4A;
  TPrinterInfo4W = _PRINTER_INFO_4W;
  PRINTER_INFO_4 = _PRINTER_INFO_4;
  PRINTER_INFO_4A = _PRINTER_INFO_4A;
  PRINTER_INFO_4W = _PRINTER_INFO_4W;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _PRINTER_INFO_5 = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrinterName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPortName: string;
    Attributes: DWORD;
    DeviceNotSelectedTimeout: DWORD;
    TransmissionRetryTimeout: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _PRINTER_INFO_5A = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrinterName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPortName: string;
    Attributes: DWORD;
    DeviceNotSelectedTimeout: DWORD;
    TransmissionRetryTimeout: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _PRINTER_INFO_5W = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrinterName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPortName: string;
    Attributes: DWORD;
    DeviceNotSelectedTimeout: DWORD;
    TransmissionRetryTimeout: DWORD;
  end;
  TPrinterInfo5 = _PRINTER_INFO_5;
  TPrinterInfo5A = _PRINTER_INFO_5A;
  TPrinterInfo5W = _PRINTER_INFO_5W;
  PRINTER_INFO_5 = _PRINTER_INFO_5;
  PRINTER_INFO_5A = _PRINTER_INFO_5A;
  PRINTER_INFO_5W = _PRINTER_INFO_5W;

  [StructLayout(LayoutKind.Sequential)]
  _PRINTER_INFO_6 = record
    dwStatus: DWORD;
  end;
  TPrinterInfo6 = _PRINTER_INFO_6;
  PRINTER_INFO_6 = _PRINTER_INFO_6;

const
  PRINTER_CONTROL_PAUSE            = 1;
  PRINTER_CONTROL_RESUME           = 2;
  PRINTER_CONTROL_PURGE            = 3;
  PRINTER_CONTROL_SET_STATUS       = 4;

  PRINTER_STATUS_PAUSED            = $00000001;
  PRINTER_STATUS_ERROR             = $00000002;
  PRINTER_STATUS_PENDING_DELETION  = $00000004;
  PRINTER_STATUS_PAPER_JAM         = $00000008;
  PRINTER_STATUS_PAPER_OUT         = $00000010;
  PRINTER_STATUS_MANUAL_FEED       = $00000020;
  PRINTER_STATUS_PAPER_PROBLEM     = $00000040;
  PRINTER_STATUS_OFFLINE           = $00000080;
  PRINTER_STATUS_IO_ACTIVE         = $00000100;
  PRINTER_STATUS_BUSY              = $00000200;
  PRINTER_STATUS_PRINTING          = $00000400;
  PRINTER_STATUS_OUTPUT_BIN_FULL   = $00000800;
  PRINTER_STATUS_NOT_AVAILABLE     = $00001000;
  PRINTER_STATUS_WAITING           = $00002000;
  PRINTER_STATUS_PROCESSING        = $00004000;
  PRINTER_STATUS_INITIALIZING      = $00008000;
  PRINTER_STATUS_WARMING_UP        = $00010000;
  PRINTER_STATUS_TONER_LOW         = $00020000;
  PRINTER_STATUS_NO_TONER          = $00040000;
  PRINTER_STATUS_PAGE_PUNT         = $00080000;
  PRINTER_STATUS_USER_INTERVENTION = $00100000;
  PRINTER_STATUS_OUT_OF_MEMORY     = $00200000;
  PRINTER_STATUS_DOOR_OPEN         = $00400000;
  PRINTER_STATUS_SERVER_UNKNOWN    = $00800000;
  PRINTER_STATUS_POWER_SAVE        = $01000000;

  PRINTER_ATTRIBUTE_QUEUED         = $00000001;
  PRINTER_ATTRIBUTE_DIRECT         = $00000002;
  PRINTER_ATTRIBUTE_DEFAULT        = $00000004;
  PRINTER_ATTRIBUTE_SHARED         = $00000008;
  PRINTER_ATTRIBUTE_NETWORK        = $00000010;
  PRINTER_ATTRIBUTE_HIDDEN         = $00000020;
  PRINTER_ATTRIBUTE_LOCAL          = $00000040;

  PRINTER_ATTRIBUTE_ENABLE_DEVQ       = $00000080;
  PRINTER_ATTRIBUTE_KEEPPRINTEDJOBS   = $00000100;
  PRINTER_ATTRIBUTE_DO_COMPLETE_FIRST = $00000200;

  PRINTER_ATTRIBUTE_WORK_OFFLINE   = $00000400;
  PRINTER_ATTRIBUTE_ENABLE_BIDI    = $00000800;
  PRINTER_ATTRIBUTE_RAW_ONLY       = $00001000;


  NO_PRIORITY   = 0;
  MAX_PRIORITY = 99;
  MIN_PRIORITY  = 1;
  DEF_PRIORITY  = 1;

type
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _JOB_INFO_1 = record
    JobId: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrinterName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pMachineName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pUserName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDocument: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDatatype: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pStatus: string;
    Status: DWORD;
    Priority: DWORD;
    Position: DWORD;
    TotalPages: DWORD;
    PagesPrinted: DWORD;
    Submitted: TSystemTime;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _JOB_INFO_1A = record
    JobId: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrinterName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pMachineName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pUserName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDocument: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDatatype: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pStatus: string;
    Status: DWORD;
    Priority: DWORD;
    Position: DWORD;
    TotalPages: DWORD;
    PagesPrinted: DWORD;
    Submitted: TSystemTime;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _JOB_INFO_1W = record
    JobId: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrinterName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pMachineName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pUserName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDocument: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDatatype: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pStatus: string;
    Status: DWORD;
    Priority: DWORD;
    Position: DWORD;
    TotalPages: DWORD;
    PagesPrinted: DWORD;
    Submitted: TSystemTime;
  end;
  TJobInfo1 = _JOB_INFO_1;
  TJobInfo1A = _JOB_INFO_1A;
  TJobInfo1W = _JOB_INFO_1W;
  JOB_INFO_1 = _JOB_INFO_1;
  JOB_INFO_1A = _JOB_INFO_1A;
  JOB_INFO_1W = _JOB_INFO_1W;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _JOB_INFO_2 = record
    JobId: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrinterName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pMachineName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pUserName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDocument: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pNotifyName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDatatype: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrintProcessor: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pParameters: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDriverName: string;
    pDevMode: IntPtr; { PDeviceMode }
    [MarshalAs(UnmanagedType.LPTStr)]
    pStatus: string;
    pSecurityDescriptor: IntPtr; { PSECURITY_DESCRIPTOR }
    Status: DWORD;
    Priority: DWORD;
    Position: DWORD;
    StartTime: DWORD;
    UntilTime: DWORD;
    TotalPages: DWORD;
    Size: DWORD;
    Submitted: TSystemTime;   { Time the job was spooled }
    Time: DWORD;              { How many seconds the job has been printing }
    PagesPrinted: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _JOB_INFO_2A = record
    JobId: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrinterName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pMachineName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pUserName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDocument: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pNotifyName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDatatype: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrintProcessor: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pParameters: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDriverName: string;
    pDevMode: IntPtr; { PDeviceModeA }
    [MarshalAs(UnmanagedType.LPTStr)]
    pStatus: string;
    pSecurityDescriptor: IntPtr; { PSECURITY_DESCRIPTOR }
    Status: DWORD;
    Priority: DWORD;
    Position: DWORD;
    StartTime: DWORD;
    UntilTime: DWORD;
    TotalPages: DWORD;
    Size: DWORD;
    Submitted: TSystemTime;   { Time the job was spooled }
    Time: DWORD;              { How many seconds the job has been printing }
    PagesPrinted: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _JOB_INFO_2W = record
    JobId: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrinterName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pMachineName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pUserName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDocument: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pNotifyName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDatatype: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pPrintProcessor: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pParameters: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDriverName: string;
    pDevMode: IntPtr; { PDeviceModeW }
    [MarshalAs(UnmanagedType.LPTStr)]
    pStatus: string;
    pSecurityDescriptor: IntPtr; { PSECURITY_DESCRIPTOR }
    Status: DWORD;
    Priority: DWORD;
    Position: DWORD;
    StartTime: DWORD;
    UntilTime: DWORD;
    TotalPages: DWORD;
    Size: DWORD;
    Submitted: TSystemTime;   { Time the job was spooled }
    Time: DWORD;              { How many seconds the job has been printing }
    PagesPrinted: DWORD;
  end;
  TJobInfo2 = _JOB_INFO_2;
  TJobInfo2A = _JOB_INFO_2A;
  TJobInfo2W = _JOB_INFO_2W;
  JOB_INFO_2 = _JOB_INFO_2;
  JOB_INFO_2A = _JOB_INFO_2A;
  JOB_INFO_2W = _JOB_INFO_2W;

  [StructLayout(LayoutKind.Sequential)]
  _JOB_INFO_3 = record
    JobId: DWORD;
    NextJobId: DWORD;
    Reserved: DWORD;
  end;
  TJobInfo3 = _JOB_INFO_3;
  JOB_INFO_3 = _JOB_INFO_3;

const
  JOB_CONTROL_PAUSE              = 1;
  JOB_CONTROL_RESUME             = 2;
  JOB_CONTROL_CANCEL             = 3;
  JOB_CONTROL_RESTART            = 4;
  JOB_CONTROL_DELETE             = 5;
  JOB_CONTROL_SENT_TO_PRINTER    = 6;
  JOB_CONTROL_LAST_PAGE_EJECTED  = 7;

  JOB_STATUS_PAUSED                   = $00000001;
  JOB_STATUS_ERROR                    = $00000002;
  JOB_STATUS_DELETING                 = $00000004;
  JOB_STATUS_SPOOLING                 = $00000008;
  JOB_STATUS_PRINTING                 = $00000010;
  JOB_STATUS_OFFLINE                  = $00000020;
  JOB_STATUS_PAPEROUT                 = $00000040;
  JOB_STATUS_PRINTED                  = $00000080;
  JOB_STATUS_DELETED                  = $00000100;
  JOB_STATUS_BLOCKED_DEVQ             = $00000200;
  JOB_STATUS_USER_INTERVENTION        = $00000400;
  JOB_STATUS_RESTART                  = $00000800;

  JOB_POSITION_UNSPECIFIED       = 0;

type
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _ADDJOB_INFO_1 = record
    [MarshalAs(UnmanagedType.LPTStr)]
    Path: string;
    JobId: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _ADDJOB_INFO_1A = record
    [MarshalAs(UnmanagedType.LPTStr)]
    Path: string;
    JobId: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _ADDJOB_INFO_1W = record
    [MarshalAs(UnmanagedType.LPTStr)]
    Path: string;
    JobId: DWORD;
  end;
  TAddJobInfo1 = _ADDJOB_INFO_1;
  TAddJobInfo1A = _ADDJOB_INFO_1A;
  TAddJobInfo1W = _ADDJOB_INFO_1W;
  ADDJOB_INFO_1 = _ADDJOB_INFO_1;
  ADDJOB_INFO_1A = _ADDJOB_INFO_1A;
  ADDJOB_INFO_1W = _ADDJOB_INFO_1W;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _DRIVER_INFO_1 = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;              { QMS 810 }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _DRIVER_INFO_1A = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;              { QMS 810 }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _DRIVER_INFO_1W = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;              { QMS 810 }
  end;
  TDriverInfo1 = _DRIVER_INFO_1;
  TDriverInfo1A = _DRIVER_INFO_1A;
  TDriverInfo1W = _DRIVER_INFO_1W;
  DRIVER_INFO_1 = _DRIVER_INFO_1;
  DRIVER_INFO_1A = _DRIVER_INFO_1A;
  DRIVER_INFO_1W = _DRIVER_INFO_1W;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _DRIVER_INFO_2 = record
    cVersion: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;              { QMS 810 }
    [MarshalAs(UnmanagedType.LPTStr)]
    pEnvironment: string;       { Win32 x86 }
    [MarshalAs(UnmanagedType.LPTStr)]
    pDriverPath: string;        { c:\drivers\pscript.dll }
    [MarshalAs(UnmanagedType.LPTStr)]
    pDataFile: string;          { c:\drivers\QMS810.PPD }
    [MarshalAs(UnmanagedType.LPTStr)]
    pConfigFile: string;        { c:\drivers\PSCRPTUI.DLL }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _DRIVER_INFO_2A = record
    cVersion: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;              { QMS 810 }
    [MarshalAs(UnmanagedType.LPTStr)]
    pEnvironment: string;       { Win32 x86 }
    [MarshalAs(UnmanagedType.LPTStr)]
    pDriverPath: string;        { c:\drivers\pscript.dll }
    [MarshalAs(UnmanagedType.LPTStr)]
    pDataFile: string;          { c:\drivers\QMS810.PPD }
    [MarshalAs(UnmanagedType.LPTStr)]
    pConfigFile: string;        { c:\drivers\PSCRPTUI.DLL }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _DRIVER_INFO_2W = record
    cVersion: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;              { QMS 810 }
    [MarshalAs(UnmanagedType.LPTStr)]
    pEnvironment: string;       { Win32 x86 }
    [MarshalAs(UnmanagedType.LPTStr)]
    pDriverPath: string;        { c:\drivers\pscript.dll }
    [MarshalAs(UnmanagedType.LPTStr)]
    pDataFile: string;          { c:\drivers\QMS810.PPD }
    [MarshalAs(UnmanagedType.LPTStr)]
    pConfigFile: string;        { c:\drivers\PSCRPTUI.DLL }
  end;
  TDriverInfo2 = _DRIVER_INFO_2;
  TDriverInfo2A = _DRIVER_INFO_2A;
  TDriverInfo2W = _DRIVER_INFO_2W;
  DRIVER_INFO_2 = _DRIVER_INFO_2;
  DRIVER_INFO_2A = _DRIVER_INFO_2A;
  DRIVER_INFO_2W = _DRIVER_INFO_2W;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _DRIVER_INFO_3 = record
    cVersion: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;                    { QMS 810 }
    [MarshalAs(UnmanagedType.LPTStr)]
    pEnvironment: string;             { Win32 x86 }
    [MarshalAs(UnmanagedType.LPTStr)]
    pDriverPath: string;              { c:\drivers\pscript.dll }
    [MarshalAs(UnmanagedType.LPTStr)]
    pDataFile: string;                { c:\drivers\QMS810.PPD }
    [MarshalAs(UnmanagedType.LPTStr)]
    pConfigFile: string;              { c:\drivers\PSCRPTUI.DLL }
    [MarshalAs(UnmanagedType.LPTStr)]
    pHelpFile: string;                { c:\drivers\PSCRPTUI.HLP }
    pDependentFiles: IntPtr;          { PSCRIPT.DLL\0QMS810.PPD\0PSCRIPTUI.DLL\0PSCRIPTUI.HLP\0PSTEST.TXT\0\0 }
    [MarshalAs(UnmanagedType.LPTStr)]
    pMonitorName: string;             { "PJL monitor" }
    [MarshalAs(UnmanagedType.LPTStr)]
    pDefaultDataType: string;         { "EMF" }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _DRIVER_INFO_3A = record
    cVersion: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;                    { QMS 810 }
    [MarshalAs(UnmanagedType.LPTStr)]
    pEnvironment: string;             { Win32 x86 }
    [MarshalAs(UnmanagedType.LPTStr)]
    pDriverPath: string;              { c:\drivers\pscript.dll }
    [MarshalAs(UnmanagedType.LPTStr)]
    pDataFile: string;                { c:\drivers\QMS810.PPD }
    [MarshalAs(UnmanagedType.LPTStr)]
    pConfigFile: string;              { c:\drivers\PSCRPTUI.DLL }
    [MarshalAs(UnmanagedType.LPTStr)]
    pHelpFile: string;                { c:\drivers\PSCRPTUI.HLP }
    pDependentFiles: IntPtr;          { PSCRIPT.DLL\0QMS810.PPD\0PSCRIPTUI.DLL\0PSCRIPTUI.HLP\0PSTEST.TXT\0\0 }
    [MarshalAs(UnmanagedType.LPTStr)]
    pMonitorName: string;             { "PJL monitor" }
    [MarshalAs(UnmanagedType.LPTStr)]
    pDefaultDataType: string;         { "EMF" }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _DRIVER_INFO_3W = record
    cVersion: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;                    { QMS 810 }
    [MarshalAs(UnmanagedType.LPTStr)]
    pEnvironment: string;             { Win32 x86 }
    [MarshalAs(UnmanagedType.LPTStr)]
    pDriverPath: string;              { c:\drivers\pscript.dll }
    [MarshalAs(UnmanagedType.LPTStr)]
    pDataFile: string;                { c:\drivers\QMS810.PPD }
    [MarshalAs(UnmanagedType.LPTStr)]
    pConfigFile: string;              { c:\drivers\PSCRPTUI.DLL }
    [MarshalAs(UnmanagedType.LPTStr)]
    pHelpFile: string;                { c:\drivers\PSCRPTUI.HLP }
    pDependentFiles: IntPtr;          { PSCRIPT.DLL\0QMS810.PPD\0PSCRIPTUI.DLL\0PSCRIPTUI.HLP\0PSTEST.TXT\0\0 }
    [MarshalAs(UnmanagedType.LPTStr)]
    pMonitorName: string;             { "PJL monitor" }
    [MarshalAs(UnmanagedType.LPTStr)]
    pDefaultDataType: string;         { "EMF" }
  end;
  TDriverInfo3 = _DRIVER_INFO_3;
  TDriverInfo3A = _DRIVER_INFO_3A;
  TDriverInfo3W = _DRIVER_INFO_3W;
  DRIVER_INFO_3 = _DRIVER_INFO_3;
  DRIVER_INFO_3A = _DRIVER_INFO_3A;
  DRIVER_INFO_3W = _DRIVER_INFO_3W;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _DOC_INFO_1 = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pDocName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pOutputFile: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDatatype: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _DOC_INFO_1A = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pDocName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pOutputFile: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDatatype: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _DOC_INFO_1W = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pDocName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pOutputFile: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDatatype: string;
  end;
  TDocInfo1 = _DOC_INFO_1;
  TDocInfo1A = _DOC_INFO_1A;
  TDocInfo1W = _DOC_INFO_1W;
  DOC_INFO_1 = _DOC_INFO_1;
  DOC_INFO_1A = _DOC_INFO_1A;
  DOC_INFO_1W = _DOC_INFO_1W;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _FORM_INFO_1 = record
    Flags: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
    Size: TSize;
    ImageableArea: TRect;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _FORM_INFO_1A = record
    Flags: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
    Size: TSize;
    ImageableArea: TRect;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _FORM_INFO_1W = record
    Flags: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
    Size: TSize;
    ImageableArea: TRect;
  end;
  TFormInfo1 = _FORM_INFO_1;
  TFormInfo1A = _FORM_INFO_1A;
  TFormInfo1W = _FORM_INFO_1W;
  FORM_INFO_1 = _FORM_INFO_1;
  FORM_INFO_1A = _FORM_INFO_1A;
  FORM_INFO_1W = _FORM_INFO_1W;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _DOC_INFO_2 = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pDocName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pOutputFile: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDatatype: string;
    dwMode: DWORD;
    JobId: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _DOC_INFO_2A = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pDocName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pOutputFile: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDatatype: string;
    dwMode: DWORD;
    JobId: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _DOC_INFO_2W = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pDocName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pOutputFile: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDatatype: string;
    dwMode: DWORD;
    JobId: DWORD;
  end;
  TDocInfo2 = _DOC_INFO_2;
  TDocInfo2A = _DOC_INFO_2A;
  TDocInfo2W = _DOC_INFO_2W;
  DOC_INFO_2 = _DOC_INFO_2;
  DOC_INFO_2A = _DOC_INFO_2A;
  DOC_INFO_2W = _DOC_INFO_2W;

const
  DI_CHANNEL              = 1;    { start direct read/write channel, }
  DI_READ_SPOOL_JOB       = 3;

  FORM_USER           = $00000000;
  FORM_BUILTIN        = $00000001;
  FORM_PRINTER        = $00000002;

type
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _PRINTPROCESSOR_INFO_1 = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _PRINTPROCESSOR_INFO_1A = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _PRINTPROCESSOR_INFO_1W = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
  end;
  TPrintProcessorInfo1 = _PRINTPROCESSOR_INFO_1;
  TPrintProcessorInfo1A = _PRINTPROCESSOR_INFO_1A;
  TPrintProcessorInfo1W = _PRINTPROCESSOR_INFO_1W;
  PRINTPROCESSOR_INFO_1 = _PRINTPROCESSOR_INFO_1;
  PRINTPROCESSOR_INFO_1A = _PRINTPROCESSOR_INFO_1A;
  PRINTPROCESSOR_INFO_1W = _PRINTPROCESSOR_INFO_1W;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _PORT_INFO_1 = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _PORT_INFO_1A = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _PORT_INFO_1W = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
  end;
  TPortInfo1 = _PORT_INFO_1;
  TPortInfo1A = _PORT_INFO_1A;
  TPortInfo1W = _PORT_INFO_1W;
  PORT_INFO_1 = _PORT_INFO_1;
  PORT_INFO_1A = _PORT_INFO_1A;
  PORT_INFO_1W = _PORT_INFO_1W;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _PORT_INFO_2 = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pPortName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pMonitorName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDescription: string;
    fPortType: DWORD;
    Reserved: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _PORT_INFO_2A = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pPortName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pMonitorName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDescription: string;
    fPortType: DWORD;
    Reserved: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _PORT_INFO_2W = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pPortName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pMonitorName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDescription: string;
    fPortType: DWORD;
    Reserved: DWORD;
  end;
  TPortInfo2 = _PORT_INFO_2;
  TPortInfo2A = _PORT_INFO_2A;
  TPortInfo2W = _PORT_INFO_2W;
  PORT_INFO_2 = _PORT_INFO_2;
  PORT_INFO_2A = _PORT_INFO_2A;
  PORT_INFO_2W = _PORT_INFO_2W;

const
  PORT_TYPE_WRITE         = $0001;
  PORT_TYPE_READ          = $0002;
  PORT_TYPE_REDIRECTED    = $0004;
  PORT_TYPE_NET_ATTACHED  = $0008;

type
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _PORT_INFO_3 = record
    dwStatus: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pszStatus: string;
    dwSeverity: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _PORT_INFO_3A = record
    dwStatus: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pszStatus: string;
    dwSeverity: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _PORT_INFO_3W = record
    dwStatus: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    pszStatus: string;
    dwSeverity: DWORD;
  end;
  TPortInfo3 = _PORT_INFO_3;
  TPortInfo3A = _PORT_INFO_3A;
  TPortInfo3W = _PORT_INFO_3W;
  PORT_INFO_3 = _PORT_INFO_3;
  PORT_INFO_3A = _PORT_INFO_3A;
  PORT_INFO_3W = _PORT_INFO_3W;

const
  PORT_STATUS_TYPE_ERROR          = 1;
  PORT_STATUS_TYPE_WARNING        = 2;
  PORT_STATUS_TYPE_INFO           = 3;

  PORT_STATUS_OFFLINE             = 1;
  PORT_STATUS_PAPER_JAM           = 2;
  PORT_STATUS_PAPER_OUT           = 3;
  PORT_STATUS_OUTPUT_BIN_FULL     = 4;
  PORT_STATUS_PAPER_PROBLEM       = 5;
  PORT_STATUS_NO_TONER            = 6;
  PORT_STATUS_DOOR_OPEN           = 7;
  PORT_STATUS_USER_INTERVENTION   = 8;
  PORT_STATUS_OUT_OF_MEMORY       = 9;

  PORT_STATUS_TONER_LOW           = 10;

  PORT_STATUS_WARMING_UP          = 11;
  PORT_STATUS_POWER_SAVE          = 12;

type
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _MONITOR_INFO_1 = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _MONITOR_INFO_1A = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _MONITOR_INFO_1W = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
  end;
  TMonitorInfo1 = _MONITOR_INFO_1;
  TMonitorInfo1A = _MONITOR_INFO_1A;
  TMonitorInfo1W = _MONITOR_INFO_1W;
  MONITOR_INFO_1 = _MONITOR_INFO_1;
  MONITOR_INFO_1A = _MONITOR_INFO_1A;
  MONITOR_INFO_1W = _MONITOR_INFO_1W;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _MONITOR_INFO_2 = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pEnvironment: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDLLName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _MONITOR_INFO_2A = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pEnvironment: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDLLName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _MONITOR_INFO_2W = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pEnvironment: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDLLName: string;
  end;
  TMonitorInfo2 = _MONITOR_INFO_2;
  TMonitorInfo2A = _MONITOR_INFO_2A;
  TMonitorInfo2W = _MONITOR_INFO_2W;
  MONITOR_INFO_2 = _MONITOR_INFO_2;
  MONITOR_INFO_2A = _MONITOR_INFO_2A;
  MONITOR_INFO_2W = _MONITOR_INFO_2W;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _DATATYPES_INFO_1 = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _DATATYPES_INFO_1A = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _DATATYPES_INFO_1W = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
  end;
  TDatatypesInfo1 = _DATATYPES_INFO_1;
  TDatatypesInfo1A = _DATATYPES_INFO_1A;
  TDatatypesInfo1W = _DATATYPES_INFO_1W;
  DATATYPES_INFO_1 = _DATATYPES_INFO_1;
  DATATYPES_INFO_1A = _DATATYPES_INFO_1A;
  DATATYPES_INFO_1W = _DATATYPES_INFO_1W;

  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _PRINTER_DEFAULTS = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pDatatype: string;
    pDevMode: IntPtr; { PDeviceMode }
    DesiredAccess: ACCESS_MASK;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _PRINTER_DEFAULTSA = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pDatatype: string;
    pDevMode: IntPtr; { PDeviceModeA }
    DesiredAccess: ACCESS_MASK;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _PRINTER_DEFAULTSW = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pDatatype: string;
    pDevMode: IntPtr; { PDeviceModeW }
    DesiredAccess: ACCESS_MASK;
  end;
  TPrinterDefaults = _PRINTER_DEFAULTS;
  TPrinterDefaultsA = _PRINTER_DEFAULTSA;
  TPrinterDefaultsW = _PRINTER_DEFAULTSW;
  PRINTER_DEFAULTS = _PRINTER_DEFAULTS;
  PRINTER_DEFAULTSA = _PRINTER_DEFAULTSA;
  PRINTER_DEFAULTSW = _PRINTER_DEFAULTSW;

function EnumPrinters(Flags: DWORD; Name: string; Level: DWORD;
  pPrinterEnum: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL; overload;
function EnumPrinters(Flags: DWORD; Name: IntPtr; Level: DWORD;
  pPrinterEnum: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL; overload;
function EnumPrintersA(Flags: DWORD; Name: string; Level: DWORD;
  pPrinterEnum: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;
function EnumPrintersW(Flags: DWORD; Name: string; Level: DWORD;
  pPrinterEnum: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;

const
  PRINTER_ENUM_DEFAULT     = $00000001;
  PRINTER_ENUM_LOCAL       = $00000002;
  PRINTER_ENUM_CONNECTIONS = $00000004;
  PRINTER_ENUM_FAVORITE    = $00000004;
  PRINTER_ENUM_NAME        = $00000008;
  PRINTER_ENUM_REMOTE      = $00000010;
  PRINTER_ENUM_SHARED      = $00000020;
  PRINTER_ENUM_NETWORK     = $00000040;

  PRINTER_ENUM_EXPAND      = $00004000;
  PRINTER_ENUM_CONTAINER   = $00008000;

  PRINTER_ENUM_ICONMASK    = $00ff0000;
  PRINTER_ENUM_ICON1       = $00010000;
  PRINTER_ENUM_ICON2       = $00020000;
  PRINTER_ENUM_ICON3       = $00040000;
  PRINTER_ENUM_ICON4       = $00080000;
  PRINTER_ENUM_ICON5       = $00100000;
  PRINTER_ENUM_ICON6       = $00200000;
  PRINTER_ENUM_ICON7       = $00400000;
  PRINTER_ENUM_ICON8       = $00800000;

function OpenPrinter(pPrinterName: string; out phPrinter: THandle;
  pDefault: IntPtr): BOOL;
function OpenPrinterA(pPrinterName: string; out phPrinter: THandle;
  pDefault: IntPtr): BOOL;
function OpenPrinterW(pPrinterName: string; out phPrinter: THandle;
  pDefault: IntPtr): BOOL;

function ResetPrinter(hPrinter: THandle; pDefault: IntPtr): BOOL;
function ResetPrinterA(hPrinter: THandle; pDefault: IntPtr): BOOL;
function ResetPrinterW(hPrinter: THandle; pDefault: IntPtr): BOOL;

function SetJob(hPrinter: THandle; JobId: DWORD; Level: DWORD;
  pJob: IntPtr; Command: DWORD): BOOL;
function SetJobA(hPrinter: THandle; JobId: DWORD; Level: DWORD;
  pJob: IntPtr; Command: DWORD): BOOL;
function SetJobW(hPrinter: THandle; JobId: DWORD; Level: DWORD;
  pJob: IntPtr; Command: DWORD): BOOL;

function GetJob(hPrinter: THandle; JobId: DWORD; Level: DWORD;
  pJob: IntPtr; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL;
function GetJobA(hPrinter: THandle; JobId: DWORD; Level: DWORD;
  pJob: IntPtr; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL;
function GetJobW(hPrinter: THandle; JobId: DWORD; Level: DWORD;
  pJob: IntPtr; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL;

function EnumJobs(hPrinter: THandle; FirstJob, NoJobs, Level: DWORD;
  pJob: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;
function EnumJobsA(hPrinter: THandle; FirstJob, NoJobs, Level: DWORD;
  pJob: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;
function EnumJobsW(hPrinter: THandle; FirstJob, NoJobs, Level: DWORD;
  pJob: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;

function AddPrinter(pName: string; Level: DWORD;
  const pPrinter: TPrinterInfo2): THandle; overload;
function AddPrinter(pName: IntPtr; Level: DWORD;
  const pPrinter: TPrinterInfo2): THandle; overload;
function AddPrinterA(pName: string; Level: DWORD;
  const pPrinter: TPrinterInfo2): THandle;
function AddPrinterW(pName: string; Level: DWORD;
  const pPrinter: TPrinterInfo2): THandle;

function DeletePrinter(hPrinter: THandle): BOOL;

function SetPrinter(hPrinter: THandle; Level: DWORD; pPrinter: IntPtr;
  Command: DWORD): BOOL;
function SetPrinterA(hPrinter: THandle; Level: DWORD; pPrinter: IntPtr;
  Command: DWORD): BOOL;
function SetPrinterW(hPrinter: THandle; Level: DWORD; pPrinter: IntPtr;
  Command: DWORD): BOOL;

function GetPrinter(hPrinter: THandle; Level: DWORD;
  pPrinter: IntPtr; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL;
function GetPrinterA(hPrinter: THandle; Level: DWORD;
  pPrinter: IntPtr; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL;
function GetPrinterW(hPrinter: THandle; Level: DWORD;
  pPrinter: IntPtr; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL;

function AddPrinterDriver(pName: string; Level: DWORD;
  pDriverInfo: IntPtr): BOOL;
function AddPrinterDriverA(pName: string; Level: DWORD;
  pDriverInfo: IntPtr): BOOL;
function AddPrinterDriverW(pName: string; Level: DWORD;
  pDriverInfo: IntPtr): BOOL;

function EnumPrinterDrivers(pName, pEnvironment: string; Level: DWORD;
  pDriverInfo: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;
function EnumPrinterDriversA(pName, pEnvironment: string; Level: DWORD;
  pDriverInfo: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;
function EnumPrinterDriversW(pName, pEnvironment: string; Level: DWORD;
  pDriverInfo: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;

function GetPrinterDriver(hPrinter: THandle; pEnvironment: string;
  Level: DWORD; pDriverInfo: IntPtr; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL;
function GetPrinterDriverA(hPrinter: THandle; pEnvironment: string;
  Level: DWORD; pDriverInfo: IntPtr; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL;
function GetPrinterDriverW(hPrinter: THandle; pEnvironment: string;
  Level: DWORD; pDriverInfo: IntPtr; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL;

function GetPrinterDriverDirectory(pName, pEnvironment: string; Level: DWORD;
  pDriverDirectory: IntPtr; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL;
function GetPrinterDriverDirectoryA(pName, pEnvironment: string; Level: DWORD;
  pDriverDirectory: IntPtr; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL;
function GetPrinterDriverDirectoryW(pName, pEnvironment: string; Level: DWORD;
  pDriverDirectory: IntPtr; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL;

function DeletePrinterDriver(pName, pEnvironment, pDriverName: string): BOOL; overload;
function DeletePrinterDriver(pName: IntPtr; pEnvironment, pDriverName: string): BOOL; overload;
function DeletePrinterDriverA(pName, pEnvironment, pDriverName: string): BOOL;
function DeletePrinterDriverW(pName, pEnvironment, pDriverName: string): BOOL;

function AddPrintProcessor(pName, pEnvironment, pPathName,
  pPrintProcessorName: string): BOOL; overload;
function AddPrintProcessor(pName: IntPtr; pEnvironment, pPathName,
  pPrintProcessorName: string): BOOL; overload;
function AddPrintProcessorA(pName, pEnvironment, pPathName,
  pPrintProcessorName: string): BOOL;
function AddPrintProcessorW(pName, pEnvironment, pPathName,
  pPrintProcessorName: string): BOOL;

function EnumPrintProcessors(pName, pEnvironment: string; Level: DWORD;
  pPrintProcessorInfo: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL; overload;
function EnumPrintProcessors(pName: IntPtr; pEnvironment: string; Level: DWORD;
  pPrintProcessorInfo: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL; overload;
function EnumPrintProcessorsA(pName, pEnvironment: string; Level: DWORD;
  pPrintProcessorInfo: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;
function EnumPrintProcessorsW(pName, pEnvironment: string; Level: DWORD;
  pPrintProcessorInfo: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;

function GetPrintProcessorDirectory(pName, pEnvironment: string; Level: DWORD;
  pPrintProcessorInfo: StringBuilder; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL; overload;
function GetPrintProcessorDirectory(pName: IntPtr; pEnvironment: string; Level: DWORD;
  pPrintProcessorInfo: StringBuilder; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL; overload;
function GetPrintProcessorDirectoryA(pName, pEnvironment: string; Level: DWORD;
  pPrintProcessorInfo: StringBuilder; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL;
function GetPrintProcessorDirectoryW(pName, pEnvironment: string; Level: DWORD;
  pPrintProcessorInfo: StringBuilder; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL;

function EnumPrintProcessorDatatypes(pName, pPrintProcessorName: string;
  Level: DWORD; pDatatypes: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL; overload;
function EnumPrintProcessorDatatypes(pName: IntPtr; pPrintProcessorName: string;
  Level: DWORD; pDatatypes: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL; overload;
function EnumPrintProcessorDatatypesA(pName, pPrintProcessorName: string;
  Level: DWORD; pDatatypes: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;
function EnumPrintProcessorDatatypesW(pName, pPrintProcessorName: string;
  Level: DWORD; pDatatypes: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;

function DeletePrintProcessor(pName, pEnvironment, pPrintProcessorName: string): BOOL; overload;
function DeletePrintProcessor(pName: INtPtr; pEnvironment, pPrintProcessorName: string): BOOL; overload;
function DeletePrintProcessorA(pName, pEnvironment, pPrintProcessorName: string): BOOL;
function DeletePrintProcessorW(pName, pEnvironment, pPrintProcessorName: string): BOOL;

function StartDocPrinter(hPrinter: THandle; Level: DWORD;
  pDocInfo: IntPtr): DWORD;
function StartDocPrinterA(hPrinter: THandle; Level: DWORD;
  pDocInfo: IntPtr): DWORD;
function StartDocPrinterW(hPrinter: THandle; Level: DWORD;
  pDocInfo: IntPtr): DWORD;

function StartPagePrinter(hPrinter: THandle): BOOL;
function WritePrinter(hPrinter: THandle; pBuf: IntPtr; cbBuf: DWORD;
  out pcWritten: DWORD): BOOL;
function EndPagePrinter(hPrinter: THandle): BOOL;
function AbortPrinter(hPrinter: THandle): BOOL;
function ReadPrinter(hPrinter: THandle; pBuf: IntPtr; cbBuf: DWORD;
  out pNoBytesRead: DWORD): BOOL;
function EndDocPrinter(hPrinter: THandle): BOOL;

function AddJob(hPrinter: THandle; Level: DWORD; out pData: TAddJobInfo1;
  cbBuf: DWORD; out pcbNeeded: DWORD): BOOL;
function AddJobA(hPrinter: THandle; Level: DWORD; out pData: TAddJobInfo1;
  cbBuf: DWORD; out pcbNeeded: DWORD): BOOL;
function AddJobW(hPrinter: THandle; Level: DWORD; out pData: TAddJobInfo1;
  cbBuf: DWORD; out pcbNeeded: DWORD): BOOL;

function ScheduleJob(hPrinter: THandle; JobId: DWORD): BOOL;
function PrinterProperties(hWnd: HWND; hPrinter: THandle): BOOL;

function DocumentProperties(hWnd: HWND; hPrinter: THandle; pDeviceName: string;
  pDevModeOutput, pDevModeInput: IntPtr; fMode: DWORD): Longint;
function DocumentPropertiesA(hWnd: HWND; hPrinter: THandle; pDeviceName: string;
  pDevModeOutput, pDevModeInput: IntPtr; fMode: DWORD): Longint;
function DocumentPropertiesW(hWnd: HWND; hPrinter: THandle; pDeviceName: string;
  pDevModeOutput, pDevModeInput: IntPtr; fMode: DWORD): Longint;

function AdvancedDocumentProperties(hWnd: HWND; hPrinter: THandle;
  pDeviceName: string; out pDevModeOutput: TDeviceMode;
  const pDevModeInput: TDeviceMode): Longint;
function AdvancedDocumentPropertiesA(hWnd: HWND; hPrinter: THandle;
  pDeviceName: string; out pDevModeOutput: TDeviceModeA;
  const pDevModeInput: TDeviceModeA): Longint;
function AdvancedDocumentPropertiesW(hWnd: HWND; hPrinter: THandle;
  pDeviceName: string; out pDevModeOutput: TDeviceModeW;
  const pDevModeInput: TDeviceModeW): Longint;

function GetPrinterData(hPrinter: THandle; pValueName: string;
  out pType: DWORD; [out] pData: TBytes;
  nSize: DWORD; out pcbNeeded: DWORD): DWORD;
function GetPrinterDataA(hPrinter: THandle; pValueName: string;
  out pType: DWORD; [out] pData: TBytes;
  nSize: DWORD; out pcbNeeded: DWORD): DWORD;
function GetPrinterDataW(hPrinter: THandle; pValueName: string;
  out pType: DWORD; [out] pData: TBytes;
  nSize: DWORD; out pcbNeeded: DWORD): DWORD;

function EnumPrinterData(hPrinter: THandle; dwIndex: DWORD; pValueName: StringBuilder;
  cbValueName: DWORD; out pcbValueName: DWORD; out pType: DWORD;
  [out] pData: TBytes; cbData: DWORD; out pcbData: DWORD): DWORD; overload;
function EnumPrinterData(hPrinter: THandle; dwIndex: DWORD; pValueName: StringBuilder;
  cbValueName: DWORD; out pcbValueName: DWORD; pType: IntPtr;
  [out] pData: TBytes; cbData: DWORD; pcbData: IntPtr): DWORD; overload;
function EnumPrinterData(hPrinter: THandle; dwIndex: DWORD; pValueName: StringBuilder;
  cbValueName: DWORD; out pcbValueName: DWORD; pType: IntPtr;
  [out] pData: TBytes; cbData: DWORD; out pcbData: DWORD): DWORD; overload;
function EnumPrinterData(hPrinter: THandle; dwIndex: DWORD; pValueName: StringBuilder;
  cbValueName: DWORD; out pcbValueName: DWORD; out pType: DWORD;
  [out] pData: TBytes; cbData: DWORD; pcbData: IntPtr): DWORD; overload;
function EnumPrinterDataA(hPrinter: THandle; dwIndex: DWORD;
  pValueName: StringBuilder; cbValueName: DWORD; out pcbValueName, pType: DWORD;
  [out] pData: TBytes; cbData: DWORD; out pcbData: DWORD): DWORD;
function EnumPrinterDataW(hPrinter: THandle; dwIndex: DWORD;
  pValueName: StringBuilder; cbValueName: DWORD; out pcbValueName, pType: DWORD;
  [out] pData: TBytes; cbData: DWORD; out pcbData: DWORD): DWORD;

function SetPrinterData(hPrinter: THandle; pValueName: string;
  dwType: DWORD; [in] pData: TBytes; cbData: DWORD): DWORD;
function SetPrinterDataA(hPrinter: THandle; pValueName: string;
  dwType: DWORD; [in] pData: TBytes; cbData: DWORD): DWORD;
function SetPrinterDataW(hPrinter: THandle; pValueName: string;
  dwType: DWORD; [in] pData: TBytes; cbData: DWORD): DWORD;

function DeletePrinterData(hPrinter: THandle; pValueName: string): DWORD;
function DeletePrinterDataA(hPrinter: THandle; pValueName: string): DWORD;
function DeletePrinterDataW(hPrinter: THandle; pValueName: string): DWORD;

const
  PRINTER_NOTIFY_TYPE = $00;
  JOB_NOTIFY_TYPE     = $01;

  PRINTER_NOTIFY_FIELD_SERVER_NAME             = $00;
  PRINTER_NOTIFY_FIELD_PRINTER_NAME            = $01;
  PRINTER_NOTIFY_FIELD_SHARE_NAME              = $02;
  PRINTER_NOTIFY_FIELD_PORT_NAME               = $03;
  PRINTER_NOTIFY_FIELD_DRIVER_NAME             = $04;
  PRINTER_NOTIFY_FIELD_COMMENT                 = $05;
  PRINTER_NOTIFY_FIELD_LOCATION                = $06;
  PRINTER_NOTIFY_FIELD_DEVMODE                 = $07;
  PRINTER_NOTIFY_FIELD_SEPFILE                 = $08;
  PRINTER_NOTIFY_FIELD_PRINT_PROCESSOR         = $09;
  PRINTER_NOTIFY_FIELD_PARAMETERS              = $0A;
  PRINTER_NOTIFY_FIELD_DATATYPE                = $0B;
  PRINTER_NOTIFY_FIELD_SECURITY_DESCRIPTOR     = $0C;
  PRINTER_NOTIFY_FIELD_ATTRIBUTES              = $0D;
  PRINTER_NOTIFY_FIELD_PRIORITY                = $0E;
  PRINTER_NOTIFY_FIELD_DEFAULT_PRIORITY        = $0F;
  PRINTER_NOTIFY_FIELD_START_TIME              = $10;
  PRINTER_NOTIFY_FIELD_UNTIL_TIME              = $11;
  PRINTER_NOTIFY_FIELD_STATUS                  = $12;
  PRINTER_NOTIFY_FIELD_STATUS_STRING           = $13;
  PRINTER_NOTIFY_FIELD_CJOBS                   = $14;
  PRINTER_NOTIFY_FIELD_AVERAGE_PPM             = $15;
  PRINTER_NOTIFY_FIELD_TOTAL_PAGES             = $16;
  PRINTER_NOTIFY_FIELD_PAGES_PRINTED           = $17;
  PRINTER_NOTIFY_FIELD_TOTAL_BYTES             = $18;
  PRINTER_NOTIFY_FIELD_BYTES_PRINTED           = $19;

  JOB_NOTIFY_FIELD_PRINTER_NAME                = $00;
  JOB_NOTIFY_FIELD_MACHINE_NAME                = $01;
  JOB_NOTIFY_FIELD_PORT_NAME                   = $02;
  JOB_NOTIFY_FIELD_USER_NAME                   = $03;
  JOB_NOTIFY_FIELD_NOTIFY_NAME                 = $04;
  JOB_NOTIFY_FIELD_DATATYPE                    = $05;
  JOB_NOTIFY_FIELD_PRINT_PROCESSOR             = $06;
  JOB_NOTIFY_FIELD_PARAMETERS                  = $07;
  JOB_NOTIFY_FIELD_DRIVER_NAME                 = $08;
  JOB_NOTIFY_FIELD_DEVMODE                     = $09;
  JOB_NOTIFY_FIELD_STATUS                      = $0A;
  JOB_NOTIFY_FIELD_STATUS_STRING               = $0B;
  JOB_NOTIFY_FIELD_SECURITY_DESCRIPTOR         = $0C;
  JOB_NOTIFY_FIELD_DOCUMENT                    = $0D;
  JOB_NOTIFY_FIELD_PRIORITY                    = $0E;
  JOB_NOTIFY_FIELD_POSITION                    = $0F;
  JOB_NOTIFY_FIELD_SUBMITTED                   = $10;
  JOB_NOTIFY_FIELD_START_TIME                  = $11;
  JOB_NOTIFY_FIELD_UNTIL_TIME                  = $12;
  JOB_NOTIFY_FIELD_TIME                        = $13;
  JOB_NOTIFY_FIELD_TOTAL_PAGES                 = $14;
  JOB_NOTIFY_FIELD_PAGES_PRINTED               = $15;
  JOB_NOTIFY_FIELD_TOTAL_BYTES                 = $16;
  JOB_NOTIFY_FIELD_BYTES_PRINTED               = $17;


type
  [StructLayout(LayoutKind.Sequential)]
  _PRINTER_NOTIFY_OPTIONS_TYPE = record
    wType: Word;
    Reserved0: Word;
    Reserved1: DWORD;
    Reserved2: DWORD;
    Count: DWORD;
    pFields: IntPtr;
  end;
  TPrinterNotifyOptionsType = _PRINTER_NOTIFY_OPTIONS_TYPE;
  PRINTER_NOTIFY_OPTIONS_TYPE = _PRINTER_NOTIFY_OPTIONS_TYPE;

const
  PRINTER_NOTIFY_OPTIONS_REFRESH  = $01;

type
  [StructLayout(LayoutKind.Sequential)]
  _PRINTER_NOTIFY_OPTIONS = record
    Version: DWORD;
    Flags: DWORD;
    Count: DWORD;
    pTypes: IntPtr; { PPrinterNotifyOptionsType }
  end;
  TPrinterNotifyOptions = _PRINTER_NOTIFY_OPTIONS;
  PRINTER_NOTIFY_OPTIONS = _PRINTER_NOTIFY_OPTIONS;

const
  PRINTER_NOTIFY_INFO_DISCARDED       = $01;

type
  [StructLayout(LayoutKind.Sequential)]
  _PRINTER_NOTIFY_INFO_DATA = record
    wType: Word;
    Field: Word;
    Reserved: DWORD;
    Id: DWORD;
    NotifyData: record
      case Integer of
        0: (adwData0, adwData1: DWORD);
        1: (Data: record
              cbBuf: DWORD;
              pBuf: IntPtr;
            end);
    end;
  end;
  TPrinterNotifyInfoData = _PRINTER_NOTIFY_INFO_DATA;
  PRINTER_NOTIFY_INFO_DATA = _PRINTER_NOTIFY_INFO_DATA;

  [StructLayout(LayoutKind.Sequential)]
  _PRINTER_NOTIFY_INFO = record
    Version: DWORD;
    Flags: DWORD;
    Count: DWORD;
    aData: IntPtr; { array[0..0] of TPrinterNotifyInfoData }
  end;
  TPrinterNotifyInfo = _PRINTER_NOTIFY_INFO;
  PRINTER_NOTIFY_INFO = _PRINTER_NOTIFY_INFO;

function WaitForPrinterChange(hPrinter: THandle; Flags: DWORD): DWORD;

function FindFirstPrinterChangeNotification(hPrinter: THandle; fdwFlags: DWORD;
  fdwOptions: DWORD; const pPrinterNotifyOptions: TPrinterNotifyOptions): THandle; overload;
function FindFirstPrinterChangeNotification(hPrinter: THandle; fdwFlags: DWORD;
  fdwOptions: DWORD; pPrinterNotifyOptions: IntPtr): THandle; overload;

function FindNextPrinterChangeNotification(hChange: THandle; out pdwChange: DWORD;
  const pPrinterNotifyOptions: TPrinterNotifyOptions; var ppPrinterNotifyInfo: IntPtr): BOOL; overload;
function FindNextPrinterChangeNotification(hChange: THandle; out pdwChange: DWORD;
  pPrinterNotifyOptions: IntPtr; var ppPrinterNotifyInfo: IntPtr): BOOL; overload;

function FreePrinterNotifyInfo(const pPrinterNotifyInfo: TPrinterNotifyInfo): BOOL;
function FindClosePrinterChangeNotification(hChange: THandle): BOOL;

const
  PRINTER_CHANGE_ADD_PRINTER              = $00000001;
  PRINTER_CHANGE_SET_PRINTER              = $00000002;
  PRINTER_CHANGE_DELETE_PRINTER           = $00000004;
  PRINTER_CHANGE_FAILED_CONNECTION_PRINTER    = $00000008;
  PRINTER_CHANGE_PRINTER                  = $000000FF;
  PRINTER_CHANGE_ADD_JOB                  = $00000100;
  PRINTER_CHANGE_SET_JOB                  = $00000200;
  PRINTER_CHANGE_DELETE_JOB               = $00000400;
  PRINTER_CHANGE_WRITE_JOB                = $00000800;
  PRINTER_CHANGE_JOB                      = $0000FF00;
  PRINTER_CHANGE_ADD_FORM                 = $00010000;
  PRINTER_CHANGE_SET_FORM                 = $00020000;
  PRINTER_CHANGE_DELETE_FORM              = $00040000;
  PRINTER_CHANGE_FORM                     = $00070000;
  PRINTER_CHANGE_ADD_PORT                 = $00100000;
  PRINTER_CHANGE_CONFIGURE_PORT           = $00200000;
  PRINTER_CHANGE_DELETE_PORT              = $00400000;
  PRINTER_CHANGE_PORT                     = $00700000;
  PRINTER_CHANGE_ADD_PRINT_PROCESSOR      = $01000000;
  PRINTER_CHANGE_DELETE_PRINT_PROCESSOR   = $04000000;
  PRINTER_CHANGE_PRINT_PROCESSOR          = $07000000;
  PRINTER_CHANGE_ADD_PRINTER_DRIVER       = $10000000;
  PRINTER_CHANGE_SET_PRINTER_DRIVER       = $20000000;
  PRINTER_CHANGE_DELETE_PRINTER_DRIVER    = $40000000;
  PRINTER_CHANGE_PRINTER_DRIVER           = $70000000;
  PRINTER_CHANGE_TIMEOUT                  = $80000000;
  PRINTER_CHANGE_ALL                      = $7777FFFF;

function PrinterMessageBox(hPrinter: THandle; Error: DWORD; hWnd: HWND; pText, pCaption: string;
  dwType: DWORD): DWORD;
function PrinterMessageBoxA(hPrinter: THandle; Error: DWORD; hWnd: HWND; pText, pCaption: string;
  dwType: DWORD): DWORD;
function PrinterMessageBoxW(hPrinter: THandle; Error: DWORD; hWnd: HWND; pText, pCaption: string;
  dwType: DWORD): DWORD;

const
  PRINTER_ERROR_INFORMATION   = $80000000;
  PRINTER_ERROR_WARNING       = $40000000;
  PRINTER_ERROR_SEVERE        = $20000000;

  PRINTER_ERROR_OUTOFPAPER    = $00000001;
  PRINTER_ERROR_JAM           = $00000002;
  PRINTER_ERROR_OUTOFTONER    = $00000004;

function ClosePrinter(hPrinter: THandle): BOOL;

function AddForm(hPrinter: THandle; Level: DWORD; const pForm: TFormInfo1): BOOL;
function AddFormA(hPrinter: THandle; Level: DWORD; const pForm: TFormInfo1): BOOL;
function AddFormW(hPrinter: THandle; Level: DWORD; const pForm: TFormInfo1): BOOL;

function DeleteForm(hPrinter: THandle; pFormName: string): BOOL;
function DeleteFormA(hPrinter: THandle; pFormName: string): BOOL;
function DeleteFormW(hPrinter: THandle; pFormName: string): BOOL;

function GetForm(hPrinter: THandle; pFormName: string; Level: DWORD;
  out pForm: TFormInfo1; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL;
function GetFormA(hPrinter: THandle; pFormName: string; Level: DWORD;
  out pForm: TFormInfo1; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL;
function GetFormW(hPrinter: THandle; pFormName: string; Level: DWORD;
  out pForm: TFormInfo1; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL;

function SetForm(hPrinter: THandle; pFormName: string; Level: DWORD;
  const pForm: TFormInfo1): BOOL;
function SetFormA(hPrinter: THandle; pFormName: string; Level: DWORD;
  const pForm: TFormInfo1): BOOL;
function SetFormW(hPrinter: THandle; pFormName: string; Level: DWORD;
  const pForm: TFormInfo1): BOOL;

function EnumForms(hPrinter: THandle; Level: DWORD; pForm: IntPtr;
  cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;
function EnumFormsA(hPrinter: THandle; Level: DWORD; pForm: IntPtr;
  cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;
function EnumFormsW(hPrinter: THandle; Level: DWORD; pForm: IntPtr;
  cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;

function EnumMonitors(pName: string; Level: DWORD; pMonitors: IntPtr;
  cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;
function EnumMonitorsA(pName: string; Level: DWORD; pMonitors: IntPtr;
  cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;
function EnumMonitorsW(pName: string; Level: DWORD; pMonitors: IntPtr;
  cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;

function AddMonitor(pName: string; Level: DWORD; const pMonitors: TMonitorInfo2): BOOL;
function AddMonitorA(pName: string; Level: DWORD; const pMonitors: TMonitorInfo2): BOOL;
function AddMonitorW(pName: string; Level: DWORD; const pMonitors: TMonitorInfo2): BOOL;

function DeleteMonitor(pName, pEnvironment, pMonitorName: string): BOOL;
function DeleteMonitorA(pName, pEnvironment, pMonitorName: string): BOOL;
function DeleteMonitorW(pName, pEnvironment, pMonitorName: string): BOOL;

function EnumPorts(pName: string; Level: DWORD; pPorts: IntPtr;
  cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;
function EnumPortsA(pName: string; Level: DWORD; pPorts: IntPtr;
  cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;
function EnumPortsW(pName: string; Level: DWORD; pPorts: IntPtr;
  cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL;

function AddPort(pName: string; hWnd: HWND; pMonitorName: string): BOOL;
function AddPortA(pName: string; hWnd: HWND; pMonitorName: string): BOOL;
function AddPortW(pName: string; hWnd: HWND; pMonitorName: string): BOOL;

function ConfigurePort(pName: string; hWnd: HWND; pPortName: string): BOOL;
function ConfigurePortA(pName: string; hWnd: HWND; pPortName: string): BOOL;
function ConfigurePortW(pName: string; hWnd: HWND; pPortName: string): BOOL;

function DeletePort(pName: string; hWnd: HWND; pPortName: string): BOOL;
function DeletePortA(pName: string; hWnd: HWND; pPortName: string): BOOL;
function DeletePortW(pName: string; hWnd: HWND; pPortName: string): BOOL;

function SetPort(pName, pPortName: string; dwLevel: DWORD;
  const pPortInfo: TPortInfo3): BOOL;
function SetPortA(pName, pPortName: string; dwLevel: DWORD;
  const pPortInfo: TPortInfo3): BOOL;
function SetPortW(pName, pPortName: string; dwLevel: DWORD;
  const pPortInfo: TPortInfo3): BOOL;

function AddPrinterConnection(pName: string): BOOL;
function AddPrinterConnectionA(pName: string): BOOL;
function AddPrinterConnectionW(pName: string): BOOL;

function DeletePrinterConnection(pName: string): BOOL;
function DeletePrinterConnectionA(pName: string): BOOL;
function DeletePrinterConnectionW(pName: string): BOOL;

function ConnectToPrinterDlg(hwnd: HWND; Flags: DWORD): THandle;

type
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Auto)]
  _PROVIDOR_INFO_1 = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pEnvironment: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDLLName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Ansi)]
  _PROVIDOR_INFO_1A = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pEnvironment: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDLLName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet = CharSet.Unicode)]
  _PROVIDOR_INFO_1W = record
    [MarshalAs(UnmanagedType.LPTStr)]
    pName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pEnvironment: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    pDLLName: string;
  end;
  TProvidorInfo1 = _PROVIDOR_INFO_1;
  TProvidorInfo1A = _PROVIDOR_INFO_1A;
  TProvidorInfo1W = _PROVIDOR_INFO_1W;
  PROVIDOR_INFO_1 = _PROVIDOR_INFO_1;
  PROVIDOR_INFO_1A = _PROVIDOR_INFO_1A;
  PROVIDOR_INFO_1W = _PROVIDOR_INFO_1W;

function AddPrintProvidor(pName: string; level: DWORD; pProvidorInfo: IntPtr): BOOL;
function AddPrintProvidorA(pName: string; level: DWORD; pProvidorInfo: IntPtr): BOOL;
function AddPrintProvidorW(pName: string; level: DWORD; pProvidorInfo: IntPtr): BOOL;

function DeletePrintProvidor(pName, pEnvironment, pPrintProvidorName: string): BOOL;
function DeletePrintProvidorA(pName, pEnvironment, pPrintProvidorName: string): BOOL;
function DeletePrintProvidorW(pName, pEnvironment, pPrintProvidorName: string): BOOL;

{ SetPrinterData and GetPrinterData Server Handle Key values }

const
  SPLREG_DEFAULT_SPOOL_DIRECTORY                    = 'DefaultSpoolDirectory';
  SPLREG_PORT_THREAD_PRIORITY_DEFAULT               = 'PortThreadPriorityDefault';
  SPLREG_PORT_THREAD_PRIORITY                       = 'PortThreadPriority';
  SPLREG_SCHEDULER_THREAD_PRIORITY_DEFAULT          = 'SchedulerThreadPriorityDefault';
  SPLREG_SCHEDULER_THREAD_PRIORITY                  = 'SchedulerThreadPriority';
  SPLREG_BEEP_ENABLED                               = 'BeepEnabled';
  SPLREG_NET_POPUP                                  = 'NetPopup';
  SPLREG_EVENT_LOG                                  = 'EventLog';
  SPLREG_MAJOR_VERSION                              = 'MajorVersion';
  SPLREG_MINOR_VERSION                              = 'MinorVersion';
  SPLREG_ARCHITECTURE                               = 'Architecture';


  SERVER_ACCESS_ADMINISTER    = $00000001;
  SERVER_ACCESS_ENUMERATE     = $00000002;
  PRINTER_ACCESS_ADMINISTER   = $00000004;
  PRINTER_ACCESS_USE          = $00000008;
  JOB_ACCESS_ADMINISTER       = $00000010;

{ Access rights for print servers }

  SERVER_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED or
    SERVER_ACCESS_ADMINISTER or SERVER_ACCESS_ENUMERATE);
  SERVER_READ = (STANDARD_RIGHTS_READ or SERVER_ACCESS_ENUMERATE);
  SERVER_WRITE = (STANDARD_RIGHTS_WRITE or
    SERVER_ACCESS_ADMINISTER or SERVER_ACCESS_ENUMERATE);
  SERVER_EXECUTE = (STANDARD_RIGHTS_EXECUTE or SERVER_ACCESS_ENUMERATE);

{ Access rights for printers }

  PRINTER_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED or
    PRINTER_ACCESS_ADMINISTER or PRINTER_ACCESS_USE);
  PRINTER_READ = (STANDARD_RIGHTS_READ or PRINTER_ACCESS_USE);
  PRINTER_WRITE = (STANDARD_RIGHTS_WRITE or PRINTER_ACCESS_USE);
  PRINTER_EXECUTE = (STANDARD_RIGHTS_EXECUTE or PRINTER_ACCESS_USE);

{ Access rights for jobs }

  JOB_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED or JOB_ACCESS_ADMINISTER);
  JOB_READ = (STANDARD_RIGHTS_READ or JOB_ACCESS_ADMINISTER);
  JOB_WRITE = (STANDARD_RIGHTS_WRITE or JOB_ACCESS_ADMINISTER);
  JOB_EXECUTE = (STANDARD_RIGHTS_EXECUTE or JOB_ACCESS_ADMINISTER);

function DeviceCapabilities(pDevice, pPort: string; fwCapability: Word;
  pOutput: IntPtr; const DevMode: TDeviceMode): Integer; overload;
function DeviceCapabilities(pDevice, pPort: string; fwCapability: Word;
  pOutput: IntPtr; DevMode: IntPtr): Integer; overload;
function DeviceCapabilitiesA(pDevice, pPort: string; fwCapability: Word;
  pOutput: IntPtr; const DevMode: TDeviceModeA): Integer;
function DeviceCapabilitiesW(pDevice, pPort: string; fwCapability: Word;
  pOutput: IntPtr; const DevMode: TDeviceModeW): Integer;

const
   winspl = 'winspool.drv';

implementation

uses
  System.Security;

[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AbortPrinter')]
function AbortPrinter; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'AddForm')]
function AddForm; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AddFormA')]
function AddFormA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'AddFormW')]
function AddFormW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'AddJob')]
function AddJob; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AddJobA')]
function AddJobA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'AddJobW')]
function AddJobW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'AddMonitor')]
function AddMonitor; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AddMonitorA')]
function AddMonitorA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'AddMonitorW')]
function AddMonitorW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'AddPort')]
function AddPort; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AddPortA')]
function AddPortA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'AddPortW')]
function AddPortW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'AddPrinter')]
function AddPrinter(pName: string; Level: DWORD;
  const pPrinter: TPrinterInfo2): THandle; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'AddPrinter')]
function AddPrinter(pName: IntPtr; Level: DWORD;
  const pPrinter: TPrinterInfo2): THandle; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AddPrinterA')]
function AddPrinterA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'AddPrinterW')]
function AddPrinterW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'AddPrinterConnection')]
function AddPrinterConnection; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AddPrinterConnectionA')]
function AddPrinterConnectionA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'AddPrinterConnectionW')]
function AddPrinterConnectionW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'AddPrinterDriver')]
function AddPrinterDriver; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AddPrinterDriverA')]
function AddPrinterDriverA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'AddPrinterDriverW')]
function AddPrinterDriverW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'AddPrintProcessor')]
function AddPrintProcessor(pName, pEnvironment, pPathName,
  pPrintProcessorName: string): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'AddPrintProcessor')]
function AddPrintProcessor(pName: IntPtr; pEnvironment, pPathName,
  pPrintProcessorName: string): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AddPrintProcessorA')]
function AddPrintProcessorA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'AddPrintProcessorW')]
function AddPrintProcessorW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'AddPrintProvidor')]
function AddPrintProvidor; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AddPrintProvidorA')]
function AddPrintProvidorA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'AddPrintProvidorW')]
function AddPrintProvidorW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'AdvancedDocumentProperties')]
function AdvancedDocumentProperties; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'AdvancedDocumentPropertiesA')]
function AdvancedDocumentPropertiesA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'AdvancedDocumentPropertiesW')]
function AdvancedDocumentPropertiesW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ClosePrinter')]
function ClosePrinter; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ConfigurePort')]
function ConfigurePort; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ConfigurePortA')]
function ConfigurePortA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ConfigurePortW')]
function ConfigurePortW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ConnectToPrinterDlg')]
function ConnectToPrinterDlg; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DeleteForm')]
function DeleteForm; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeleteFormA')]
function DeleteFormA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DeleteFormW')]
function DeleteFormW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DeleteMonitor')]
function DeleteMonitor; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeleteMonitorA')]
function DeleteMonitorA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DeleteMonitorW')]
function DeleteMonitorW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DeletePort')]
function DeletePort; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeletePortA')]
function DeletePortA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DeletePortW')]
function DeletePortW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeletePrinter')]
function DeletePrinter; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DeletePrinterConnection')]
function DeletePrinterConnection; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeletePrinterConnectionA')]
function DeletePrinterConnectionA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DeletePrinterConnectionW')]
function DeletePrinterConnectionW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DeletePrinterData')]
function DeletePrinterData; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeletePrinterDataA')]
function DeletePrinterDataA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DeletePrinterDataW')]
function DeletePrinterDataW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DeletePrinterDriver')]
function DeletePrinterDriver(pName, pEnvironment, pDriverName: string): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DeletePrinterDriver')]
function DeletePrinterDriver(pName: IntPtr; pEnvironment, pDriverName: string): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeletePrinterDriverA')]
function DeletePrinterDriverA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DeletePrinterDriverW')]
function DeletePrinterDriverW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DeletePrintProcessor')]
function DeletePrintProcessor(pName, pEnvironment, pPrintProcessorName: string): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DeletePrintProcessor')]
function DeletePrintProcessor(pName: INtPtr; pEnvironment, pPrintProcessorName: string): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeletePrintProcessorA')]
function DeletePrintProcessorA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DeletePrintProcessorW')]
function DeletePrintProcessorW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DeletePrintProvidor')]
function DeletePrintProvidor; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeletePrintProvidorA')]
function DeletePrintProvidorA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DeletePrintProvidorW')]
function DeletePrintProvidorW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DeviceCapabilities')]
function DeviceCapabilities(pDevice, pPort: string; fwCapability: Word;
  pOutput: IntPtr; const DevMode: TDeviceMode): Integer; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DeviceCapabilities')]
function DeviceCapabilities(pDevice, pPort: string; fwCapability: Word;
  pOutput: IntPtr; DevMode: IntPtr): Integer; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DeviceCapabilitiesA')]
function DeviceCapabilitiesA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DeviceCapabilitiesW')]
function DeviceCapabilitiesW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'DocumentProperties')]
function DocumentProperties; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DocumentPropertiesA')]
function DocumentPropertiesA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'DocumentPropertiesW')]
function DocumentPropertiesW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EndDocPrinter')]
function EndDocPrinter; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EndPagePrinter')]
function EndPagePrinter; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumForms')]
function EnumForms; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumFormsA')]
function EnumFormsA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumFormsW')]
function EnumFormsW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumJobs')]
function EnumJobs; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumJobsA')]
function EnumJobsA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumJobsW')]
function EnumJobsW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumMonitors')]
function EnumMonitors; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumMonitorsA')]
function EnumMonitorsA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumMonitorsW')]
function EnumMonitorsW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumPorts')]
function EnumPorts; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumPortsA')]
function EnumPortsA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumPortsW')]
function EnumPortsW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumPrinterData')]
function EnumPrinterData(hPrinter: THandle; dwIndex: DWORD; pValueName: StringBuilder;
  cbValueName: DWORD; out pcbValueName: DWORD; out pType: DWORD;
  [out] pData: TBytes; cbData: DWORD; out pcbData: DWORD): DWORD; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumPrinterData')]
function EnumPrinterData(hPrinter: THandle; dwIndex: DWORD; pValueName: StringBuilder;
  cbValueName: DWORD; out pcbValueName: DWORD; pType: IntPtr;
  [out] pData: TBytes; cbData: DWORD; pcbData: IntPtr): DWORD; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumPrinterData')]
function EnumPrinterData(hPrinter: THandle; dwIndex: DWORD; pValueName: StringBuilder;
  cbValueName: DWORD; out pcbValueName: DWORD; pType: IntPtr;
  [out] pData: TBytes; cbData: DWORD; out pcbData: DWORD): DWORD; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumPrinterData')]
function EnumPrinterData(hPrinter: THandle; dwIndex: DWORD; pValueName: StringBuilder;
  cbValueName: DWORD; out pcbValueName: DWORD; out pType: DWORD;
  [out] pData: TBytes; cbData: DWORD; pcbData: IntPtr): DWORD; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumPrinterDataA')]
function EnumPrinterDataA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumPrinterDataW')]
function EnumPrinterDataW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumPrinterDrivers')]
function EnumPrinterDrivers; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumPrinterDriversA')]
function EnumPrinterDriversA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumPrinterDriversW')]
function EnumPrinterDriversW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumPrinters')]
function EnumPrinters(Flags: DWORD; Name: string; Level: DWORD;
  pPrinterEnum: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumPrinters')]
function EnumPrinters(Flags: DWORD; Name: IntPtr; Level: DWORD;
  pPrinterEnum: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumPrintersA')]
function EnumPrintersA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumPrintersW')]
function EnumPrintersW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumPrintProcessorDatatypes')]
function EnumPrintProcessorDatatypes(pName, pPrintProcessorName: string;
  Level: DWORD; pDatatypes: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumPrintProcessorDatatypes')]
function EnumPrintProcessorDatatypes(pName: IntPtr; pPrintProcessorName: string;
  Level: DWORD; pDatatypes: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumPrintProcessorDatatypesA')]
function EnumPrintProcessorDatatypesA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumPrintProcessorDatatypesW')]
function EnumPrintProcessorDatatypesW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumPrintProcessors')]
function EnumPrintProcessors(pName, pEnvironment: string; Level: DWORD;
  pPrintProcessorInfo: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'EnumPrintProcessors')]
function EnumPrintProcessors(pName: IntPtr; pEnvironment: string; Level: DWORD;
  pPrintProcessorInfo: IntPtr; cbBuf: DWORD; out pcbNeeded, pcReturned: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'EnumPrintProcessorsA')]
function EnumPrintProcessorsA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'EnumPrintProcessorsW')]
function EnumPrintProcessorsW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindClosePrinterChangeNotification')]
function FindClosePrinterChangeNotification; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindFirstPrinterChangeNotification')]
function FindFirstPrinterChangeNotification(hPrinter: THandle; fdwFlags: DWORD;
  fdwOptions: DWORD; const pPrinterNotifyOptions: TPrinterNotifyOptions): THandle; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FindFirstPrinterChangeNotification')]
function FindFirstPrinterChangeNotification(hPrinter: THandle; fdwFlags: DWORD;
  fdwOptions: DWORD; pPrinterNotifyOptions: IntPtr): THandle; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FindNextPrinterChangeNotification')]
function FindNextPrinterChangeNotification(hChange: THandle; out pdwChange: DWORD;
  const pPrinterNotifyOptions: TPrinterNotifyOptions; var ppPrinterNotifyInfo: IntPtr): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'FindNextPrinterChangeNotification')]
function FindNextPrinterChangeNotification(hChange: THandle; out pdwChange: DWORD;
  pPrinterNotifyOptions: IntPtr; var ppPrinterNotifyInfo: IntPtr): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'FreePrinterNotifyInfo')]
function FreePrinterNotifyInfo; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetForm')]
function GetForm; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetFormA')]
function GetFormA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetFormW')]
function GetFormW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetJob')]
function GetJob; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetJobA')]
function GetJobA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetJobW')]
function GetJobW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetPrinter')]
function GetPrinter; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetPrinterA')]
function GetPrinterA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetPrinterW')]
function GetPrinterW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetPrinterData')]
function GetPrinterData; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetPrinterDataA')]
function GetPrinterDataA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetPrinterDataW')]
function GetPrinterDataW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetPrinterDriver')]
function GetPrinterDriver; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetPrinterDriverA')]
function GetPrinterDriverA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetPrinterDriverW')]
function GetPrinterDriverW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetPrinterDriverDirectory')]
function GetPrinterDriverDirectory; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetPrinterDriverDirectoryA')]
function GetPrinterDriverDirectoryA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetPrinterDriverDirectoryW')]
function GetPrinterDriverDirectoryW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetPrintProcessorDirectory')]
function GetPrintProcessorDirectory(pName, pEnvironment: string; Level: DWORD;
  pPrintProcessorInfo: StringBuilder; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'GetPrintProcessorDirectory')]
function GetPrintProcessorDirectory(pName: IntPtr; pEnvironment: string; Level: DWORD;
  pPrintProcessorInfo: StringBuilder; cbBuf: DWORD; out pcbNeeded: DWORD): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetPrintProcessorDirectoryA')]
function GetPrintProcessorDirectoryA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'GetPrintProcessorDirectoryW')]
function GetPrintProcessorDirectoryW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'OpenPrinter')]
function OpenPrinter; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OpenPrinterA')]
function OpenPrinterA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'OpenPrinterW')]
function OpenPrinterW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'PrinterMessageBox')]
function PrinterMessageBox; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PrinterMessageBoxA')]
function PrinterMessageBoxA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'PrinterMessageBoxW')]
function PrinterMessageBoxW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PrinterProperties')]
function PrinterProperties; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ReadPrinter')]
function ReadPrinter; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'ResetPrinter')]
function ResetPrinter; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ResetPrinterA')]
function ResetPrinterA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'ResetPrinterW')]
function ResetPrinterW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'ScheduleJob')]
function ScheduleJob; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SetForm')]
function SetForm; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetFormA')]
function SetFormA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SetFormW')]
function SetFormW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SetJob')]
function SetJob; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetJobA')]
function SetJobA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SetJobW')]
function SetJobW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SetPort')]
function SetPort; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetPortA')]
function SetPortA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SetPortW')]
function SetPortW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SetPrinter')]
function SetPrinter; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetPrinterA')]
function SetPrinterA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SetPrinterW')]
function SetPrinterW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'SetPrinterData')]
function SetPrinterData; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SetPrinterDataA')]
function SetPrinterDataA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'SetPrinterDataW')]
function SetPrinterDataW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'StartDocPrinter')]
function StartDocPrinter; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'StartDocPrinterA')]
function StartDocPrinterA; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'StartDocPrinterW')]
function StartDocPrinterW; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'StartPagePrinter')]
function StartPagePrinter; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WaitForPrinterChange')]
function WaitForPrinterChange; external;
[SuppressUnmanagedCodeSecurity, DllImport(winspl, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'WritePrinter')]
function WritePrinter; external;

end.
